//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: safe
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <limits.h>

// Define custom types for clarity and safety
typedef uint8_t byte;
typedef int8_t sbyte;
typedef uint16_t word;
typedef int16_t sword;
typedef uint32_t dword;
typedef int32_t sdword;
typedef uint64_t qword;
typedef int64_t sqword;

// Define a macro to check for overflow/underflow in signed arithmetic operations
#define CHECK_OVERFLOW(expr) (((expr) > INT_MAX) || ((expr) < INT_MIN))

// Define a macro to check for overflow/underflow in unsigned arithmetic operations
#define CHECK_UOVERFLOW(expr) (((expr) > UINT_MAX))

// Define a macro to check for divide-by-zero errors
#define CHECK_DIVZERO(expr) ((expr) == 0)

// Define a macro to check for invalid shifts
#define CHECK_SHIFT(expr) (((expr) < 0) || ((expr) >= sizeof(expr) * CHAR_BIT))

// Define bitwise operators using macros to ensure type safety
#define BITWISE_AND(a, b) ((a) & (b))
#define BITWISE_OR(a, b) ((a) | (b))
#define BITWISE_XOR(a, b) ((a) ^ (b))
#define BITWISE_NOT(a) (~(a))
#define BITWISE_SHL(a, b) (((a) << (b)) & UINT32_MAX)  // Ensures 32-bit result even for 64-bit operands
#define BITWISE_SHR(a, b) ((a) >> (b))

int main() {
    // Initialize variables
    byte a = 0x55;
    sbyte b = -0x12;
    word c = 0xABCD;
    sword d = -0x3456;
    dword e = 0x12345678;
    sdword f = -0x98765432;
    qword g = 0xABCDEF0123456789;
    sqword h = -0x1234567890ABCDEF;

    // Perform bitwise operations
    printf("a = 0x%02X\n", a);
    printf("b = 0x%02X\n", b);
    printf("c = 0x%04X\n", c);
    printf("d = 0x%04X\n", d);
    printf("e = 0x%08X\n", e);
    printf("f = 0x%08X\n", f);
    printf("g = 0x%016llX\n", g);
    printf("h = 0x%016llX\n\n", h);

    printf("BITWISE_AND(a, b) = 0x%02X\n", BITWISE_AND(a, b));
    printf("BITWISE_OR(a, b) = 0x%02X\n", BITWISE_OR(a, b));
    printf("BITWISE_XOR(a, b) = 0x%02X\n", BITWISE_XOR(a, b));
    printf("BITWISE_NOT(a) = 0x%02X\n", BITWISE_NOT(a));
    printf("BITWISE_SHL(a, 2) = 0x%04X\n", BITWISE_SHL(a, 2));
    printf("BITWISE_SHR(a, 2) = 0x%02X\n\n", BITWISE_SHR(a, 2));

    printf("BITWISE_AND(c, d) = 0x%04X\n", BITWISE_AND(c, d));
    printf("BITWISE_OR(c, d) = 0x%04X\n", BITWISE_OR(c, d));
    printf("BITWISE_XOR(c, d) = 0x%04X\n", BITWISE_XOR(c, d));
    printf("BITWISE_NOT(c) = 0x%04X\n", BITWISE_NOT(c));
    printf("BITWISE_SHL(c, 4) = 0x%08X\n", BITWISE_SHL(c, 4));
    printf("BITWISE_SHR(c, 4) = 0x%02X\n\n", BITWISE_SHR(c, 4));

    printf("BITWISE_AND(e, f) = 0x%08X\n", BITWISE_AND(e, f));
    printf("BITWISE_OR(e, f) = 0x%08X\n", BITWISE_OR(e, f));
    printf("BITWISE_XOR(e, f) = 0x%08X\n", BITWISE_XOR(e, f));
    printf("BITWISE_NOT(e) = 0x%08X\n", BITWISE_NOT(e));
    printf("BITWISE_SHL(e, 8) = 0x%016llX\n", BITWISE_SHL(e, 8));
    printf("BITWISE_SHR(e, 8) = 0x%04X\n\n", BITWISE_SHR(e, 8));

    printf("BITWISE_AND(g, h) = 0x%016llX\n", BITWISE_AND(g, h));
    printf("BITWISE_OR(g, h) = 0x%016llX\n", BITWISE_OR(g, h));
    printf("BITWISE_XOR(g, h) = 0x%016llX\n", BITWISE_XOR(g, h));
    printf("BITWISE_NOT(g) = 0x%016llX\n", BITWISE_NOT(g));
    printf("BITWISE_SHL(g, 16) = 0x%032llX\n", BITWISE_SHL(g, 16));
    printf("BITWISE_SHR(g, 16) = 0x%08X\n", BITWISE_SHR(g, 16));

    return 0;
}