//Code Llama-13B DATASET v1.0 Category: Networking ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main(int argc, char **argv) {
  int sock, client_sock, len, bytes_read;
  struct sockaddr_in server, client;
  char *message, buffer[256];

  // Create socket
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Socket creation failed");
    exit(1);
  }

  // Initialize server address
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = htons(8080);

  // Bind server address to socket
  if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
    perror("Bind failed");
    exit(1);
  }

  // Listen for incoming connections
  if (listen(sock, 3) < 0) {
    perror("Listen failed");
    exit(1);
  }

  printf("Server listening on port %d\n", 8080);

  // Accept incoming connections
  client_sock = accept(sock, (struct sockaddr *)&client, (socklen_t *)&len);
  if (client_sock < 0) {
    perror("Accept failed");
    exit(1);
  }

  printf("Client connected with address: %s\n", inet_ntoa(client.sin_addr));

  // Read message from client
  bytes_read = read(client_sock, buffer, 256);
  if (bytes_read < 0) {
    perror("Read failed");
    exit(1);
  }

  // Send message to client
  bytes_read = write(client_sock, buffer, bytes_read);
  if (bytes_read < 0) {
    perror("Write failed");
    exit(1);
  }

  // Close socket
  close(client_sock);
  close(sock);

  return 0;
}