//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

struct message {
    char *data;
    int len;
};

int main() {
    int sock;
    struct message message;

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    // Set address and port number
    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(PORT),
        .sin_addr.s_addr = inet_addr("127.0.0.1")
    };

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("Connection failed");
        exit(1);
    }

    // Send a message
    message.data = "Hello, server!";
    message.len = strlen(message.data);
    send(sock, &message, message.len, 0);

    // Receive a message
    char buffer[1024];
    int bytes_received = recv(sock, buffer, 1024, 0);
    if (bytes_received < 0) {
        perror("Receiving failed");
        exit(1);
    }

    // Print the received message
    printf("%s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}