//Gemma-7B DATASET v1.0 Category: Building a SMTP Client ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>

#define SERVER "localhost"
#define PORT 25

int main()
{
    int sockfd, newsockfd, port, clientlen, send_len, recv_len;
    char buffer[1024], send_buffer[1024], recv_buffer[1024];
    struct sockaddr_in server_addr, client_addr;

    sockfd = socket(AF_INET, SOCK_STREAM, htons(PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    server_addr.sin_addr.s_addr = inet_addr(SERVER);

    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    clientlen = sizeof(client_addr);

    newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &clientlen);
    if (newsockfd < 0)
    {
        perror("Error accepting connection");
        exit(1);
    }

    recv_len = recv(newsockfd, recv_buffer, 1024, 0);
    if (recv_len < 0)
    {
        perror("Error receiving data");
        exit(1);
    }

    printf("Received: %s", recv_buffer);

    send_len = send(newsockfd, send_buffer, 1024, 0);
    if (send_len < 0)
    {
        perror("Error sending data");
        exit(1);
    }

    close(newsockfd);
    close(sockfd);

    return 0;
}