//GPT-4o-mini DATASET v1.0 Category: Building a IMAP Client ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>

#define PORT 993  // IMAP over SSL port
#define BUFFER_SIZE 1024

// Function to handle errors
void handleError(const char *msg) {
    perror(msg);
    exit(EXIT_FAILURE);
}

// Function to print the welcome message
void printWelcomeMessage() {
    printf("🎉 Welcome to the Wondrous IMAP Client! 🎉\n");
    printf("🚀 Let's fetch your email folders and unravel the mysteries within! 🚀\n");
}

// Function to create a socket and connect to the IMAP server
int connectToServer(const char *server) {
    int sockfd;
    struct sockaddr_in server_addr;

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) handleError("Socket creation failed");

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    if (inet_pton(AF_INET, server, &server_addr.sin_addr) <= 0)
        handleError("Invalid address/ Address not supported");

    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
        handleError("Connection failed");

    return sockfd;
}

// Function to send a command to the IMAP server and receive the response
void sendCommand(int sockfd, const char *cmd) {
    char buffer[BUFFER_SIZE] = {0};
    send(sockfd, cmd, strlen(cmd), 0);
    recv(sockfd, buffer, BUFFER_SIZE, 0);
    
    printf("💬 Server Response: %s\n", buffer);
}

// Function to list mail folders
void listMailFolders(int sockfd) {
    const char *listFoldersCmd = "A001 LIST \"\" \"*\"\r\n";
    sendCommand(sockfd, listFoldersCmd);
}

// Main function
int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <IMAP_Server_IP>\n", argv[0]);
        return EXIT_FAILURE;
    }

    printWelcomeMessage();

    // Connect to the IMAP server
    int sockfd = connectToServer(argv[1]);

    // Example of listing mail folders
    printf("\n🌈 Fetching your glorious mail folders...\n");
    listMailFolders(sockfd);
    
    // Closing the socket
    close(sockfd);

    printf("\n✨ Thank you for using the Wondrous IMAP Client! Until next time! ✨\n");
    return EXIT_SUCCESS;
}