//Falcon-180B DATASET v1.0 Category: Graph representation ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 200
#define INF 9999

typedef struct {
    int id;
    char name[20];
} Node;

typedef struct {
    int from;
    int to;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];

int num_nodes = 0;
int num_edges = 0;

bool add_node(char* name) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes exceeded.\n");
        return false;
    }
    strcpy(nodes[num_nodes].name, name);
    return true;
}

bool add_edge(int from, int to, int weight) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges exceeded.\n");
        return false;
    }
    edges[num_edges].from = from;
    edges[num_edges].to = to;
    edges[num_edges].weight = weight;
    num_edges++;
    return true;
}

void print_graph() {
    printf("Node ID\tNode Name\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d\t%s\n", nodes[i].id, nodes[i].name);
    }
    printf("\n");
    printf("From\tTo\tWeight\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d\t%d\t%d\n", edges[i].from, edges[i].to, edges[i].weight);
    }
}

int main() {
    add_node("A");
    add_node("B");
    add_node("C");
    add_node("D");
    add_node("E");

    add_edge(0, 1, 5);
    add_edge(0, 2, 3);
    add_edge(1, 3, 7);
    add_edge(2, 3, 2);
    add_edge(2, 4, 4);

    print_graph();

    return 0;
}