//Code Llama-13B DATASET v1.0 Category: Phone Book ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LEN 30
#define MAX_PHONE_LEN 15
#define MAX_PHONEBOOK_SIZE 100

struct phone_entry {
    char name[MAX_NAME_LEN];
    char phone[MAX_PHONE_LEN];
};

struct phone_book {
    struct phone_entry entries[MAX_PHONEBOOK_SIZE];
    int num_entries;
};

void add_entry(struct phone_book *phone_book, char *name, char *phone) {
    struct phone_entry new_entry = {0};
    strcpy(new_entry.name, name);
    strcpy(new_entry.phone, phone);
    phone_book->entries[phone_book->num_entries] = new_entry;
    phone_book->num_entries++;
}

void remove_entry(struct phone_book *phone_book, char *name) {
    int i;
    for (i = 0; i < phone_book->num_entries; i++) {
        if (strcmp(phone_book->entries[i].name, name) == 0) {
            phone_book->num_entries--;
            phone_book->entries[i] = phone_book->entries[phone_book->num_entries];
            return;
        }
    }
}

void print_entry(struct phone_entry *entry) {
    printf("%s: %s\n", entry->name, entry->phone);
}

void print_phone_book(struct phone_book *phone_book) {
    int i;
    for (i = 0; i < phone_book->num_entries; i++) {
        print_entry(&phone_book->entries[i]);
    }
}

int main() {
    struct phone_book phone_book = {0};
    add_entry(&phone_book, "John", "555-1234");
    add_entry(&phone_book, "Jane", "555-5678");
    add_entry(&phone_book, "Bob", "555-9012");
    print_phone_book(&phone_book);
    remove_entry(&phone_book, "Jane");
    print_phone_book(&phone_book);
    return 0;
}