//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define DB_NAME "example.db"
#define QUERY_SIZE 256

// Function declarations
void checkDB(sqlite3 *db);
void checkQuery(int rc);
void checkStatement(sqlite3_stmt *stmt);
void executeQuery(sqlite3 *db, const char *query);
void closeDatabase(sqlite3 *db);
void createTable(sqlite3 *db);

int main() {
    sqlite3 *db = NULL;
    
    // Opening the database
    int rc = sqlite3_open(DB_NAME, &db);
    checkQuery(rc);
    
    // Creating a table if it doesn't exist
    createTable(db);

    char query[QUERY_SIZE];
    snprintf(query, sizeof(query), "SELECT * FROM users;");

    // Execute a sample query
    executeQuery(db, query);
    
    // Close the database connection
    closeDatabase(db);
    
    return 0;
}

void checkDB(sqlite3 *db) {
    if (db == NULL) {
        fprintf(stderr, "Database connection failed.\n");
        exit(EXIT_FAILURE);
    }
}

void checkQuery(int rc) {
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQLite error: %s\n", sqlite3_errmsg(sqlite3_open(DB_NAME, NULL)));
        exit(EXIT_FAILURE);
    }
}

void checkStatement(sqlite3_stmt *stmt) {
    if (stmt == NULL) {
        fprintf(stderr, "Failed to create statement.\n");
        exit(EXIT_FAILURE);
    }
}

void createTable(sqlite3 *db) {
    const char *sql = "CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY, name TEXT NOT NULL);";
    char *err_msg = NULL;

    int rc = sqlite3_exec(db, sql, NULL, NULL, &err_msg);
    if (rc != SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
        exit(EXIT_FAILURE);
    }
}

void executeQuery(sqlite3 *db, const char *query) {
    sqlite3_stmt *stmt;
    checkDB(db);
    
    int rc = sqlite3_prepare_v2(db, query, -1, &stmt, NULL);
    checkStatement(stmt);
    
    rc = sqlite3_step(stmt);
    
    if (rc == SQLITE_ROW) {
        // While there's data to read
        do {
            int id = sqlite3_column_int(stmt, 0);
            const unsigned char *name = sqlite3_column_text(stmt, 1);
            printf("User ID: %d, Name: %s\n", id, name);
            rc = sqlite3_step(stmt);
        } while (rc == SQLITE_ROW);
    } else if (rc != SQLITE_DONE) {
        fprintf(stderr, "Execution error: %s\n", sqlite3_errmsg(db));
    }
    
    sqlite3_finalize(stmt);
}

void closeDatabase(sqlite3 *db) {
    if (db != NULL) {
        sqlite3_close(db);
    } else {
        fprintf(stderr, "Attempted to close a NULL database reference.\n");
    }
}