//GEMINI-pro DATASET v1.0 Category: Checkers Game ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>

#define BOARD_SIZE 8
#define EMPTY 0
#define BLACK 1
#define WHITE 2

typedef struct {
  int row;
  int col;
} Position;

typedef struct {
  int color;
  Position position;
} Piece;

typedef struct {
  Piece board[BOARD_SIZE][BOARD_SIZE];
} Board;

void print_board(Board *board) {
  printf("  ");
  for (int i = 0; i < BOARD_SIZE; i++) {
    printf("%d ", i);
  }
  printf("\n");

  for (int i = 0; i < BOARD_SIZE; i++) {
    printf("%d ", i);
    for (int j = 0; j < BOARD_SIZE; j++) {
      switch (board->board[i][j].color) {
        case EMPTY:
          printf("  ");
          break;
        case BLACK:
          printf("B ");
          break;
        case WHITE:
          printf("W ");
          break;
      }
    }
    printf("\n");
  }
}

int main() {
  Board board;

  // Initialize the board
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      board.board[i][j].color = EMPTY;
    }
  }

  // Place the pieces on the board
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      board.board[i][j].color = BLACK;
    }
  }

  for (int i = 5; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      board.board[i][j].color = WHITE;
    }
  }

  // Print the board
  print_board(&board);

  return 0;
}