//GEMINI-pro DATASET v1.0 Category: Data mining ; Style: retro
// Ye Olde Data Minin' Emporium

#include <stdio.h>
#include <stdlib.h>

// Avast, mateys! This be a struct to hold yer data
typedef struct {
  char *name;
  int age;
  int height;
  int weight;
} Pirate;

// Initialize yer data set with a hearty crew of scurvy dogs
Pirate crew[] = {
  {"Blackbeard", 55, 6, 250},
  {"Calico Jack", 38, 5, 180},
  {"Captain Kidd", 42, 5, 190},
  {"Charles Vane", 36, 5, 170},
  {"Edward Teach", 40, 6, 220},
};

// Function to print a pirate's stats
void printPirate(Pirate *p) {
  printf("Avast! Meet %s, the scurvy dog!\n", p->name);
  printf("Age: %d\n", p->age);
  printf("Height: %d feet\n", p->height);
  printf("Weight: %d pounds\n\n", p->weight);
}

// Function to find the tallest pirate
int findTallest(Pirate *crew, int size) {
  int tallestIndex = 0;
  for (int i = 1; i < size; i++) {
    if (crew[i].height > crew[tallestIndex].height) {
      tallestIndex = i;
    }
  }
  return tallestIndex;
}

// Main function to shiver yer timbers
int main() {
  // Welcome the landlubber to yer data minin' emporium
  printf("Ahoy there, matey! Welcome to Ye Olde Data Minin' Emporium.\n");
  printf("We be havin' a fine collection o' scurvy dogs for ye to explore!\n\n");

  // Print the stats of each pirate
  for (int i = 0; i < 5; i++) {
    printPirate(&crew[i]);
  }

  // Find the tallest pirate
  int tallestIndex = findTallest(crew, 5);
  printf("Avast! The tallest pirate be %s, a towering %d feet tall!\n",
         crew[tallestIndex].name, crew[tallestIndex].height);

  // Bid farewell to the landlubber
  printf("\nThank ye for visitin' our emporium, matey! May yer sails be filled with data!\n");

  return 0;
}