//Falcon-180B DATASET v1.0 Category: RAM usage monitor ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME_LENGTH 16

typedef struct {
    int pid;
    char name[MAX_PROCESS_NAME_LENGTH];
    int ram_usage;
} Process;

Process processes[MAX_PROCESSES];
int num_processes = 0;

void add_process(int pid, char* name, int ram_usage) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached.\n");
        return;
    }

    strncpy(processes[num_processes].name, name, MAX_PROCESS_NAME_LENGTH);
    processes[num_processes].pid = pid;
    processes[num_processes].ram_usage = ram_usage;

    num_processes++;
}

void remove_process(int pid) {
    int i;

    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            num_processes--;

            for (int j = i; j < num_processes; j++) {
                processes[j] = processes[j + 1];
            }

            break;
        }
    }
}

void update_process_ram_usage(int pid, int ram_usage) {
    int i;

    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            processes[i].ram_usage = ram_usage;
            break;
        }
    }
}

void print_processes() {
    printf("PID\tName\tRAM Usage\n");

    for (int i = 0; i < num_processes; i++) {
        printf("%d\t%s\t%d\n", processes[i].pid, processes[i].name, processes[i].ram_usage);
    }
}

int main() {
    add_process(1, "init", 1000);
    add_process(2, "bash", 2000);
    add_process(3, "chrome", 3000);

    print_processes();

    remove_process(2);

    print_processes();

    update_process_ram_usage(1, 500);
    update_process_ram_usage(3, 4000);

    print_processes();

    return 0;
}