//Gemma-7B DATASET v1.0 Category: Planet Gravity Simulation ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define G 6.674e-11

typedef struct CelestialBody {
    double mass;
    double x;
    double y;
    double z;
    double vx;
    double vy;
    double vz;
} CelestialBody;

void calculate_gravity(CelestialBody *body1, CelestialBody *body2) {
    double dx = body2->x - body1->x;
    double dy = body2->y - body1->y;
    double dz = body2->z - body1->z;

    double distance_squared = dx * dx + dy * dy + dz * dz;

    double force = G * body2->mass * body1->mass / distance_squared;

    body1->vx += force * dx / body1->mass;
    body1->vy += force * dy / body1->mass;
    body1->vz += force * dz / body1->mass;
}

int main() {
    CelestialBody body1 = {
        .mass = 1000,
        .x = 0,
        .y = 0,
        .z = 0,
        .vx = 0,
        .vy = 0,
        .vz = 0,
    };

    CelestialBody body2 = {
        .mass = 1000,
        .x = 10,
        .y = 0,
        .z = 0,
        .vx = 0,
        .vy = 0,
        .vz = 0,
    };

    calculate_gravity(&body1, &body2);

    printf("Body 1's new position:");
    printf("\n(x, y, z) = (%f, %f, %f)", body1.x, body1.y, body1.z);

    printf("\nBody 1's new velocity:");
    printf("\n(vx, vy, vz) = (%f, %f, %f)", body1.vx, body1.vy, body1.vz);

    return 0;
}