//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// A custom comparison function for qsort() that sorts strings in descending order
int compare_strings_descending(const void *a, const void *b) {
  const char *str1 = (const char *)a;
  const char *str2 = (const char *)b;

  // Return a negative value if str1 is greater than str2,
  // a positive value if str1 is less than str2,
  // and 0 if str1 is equal to str2
  return -strcmp(str1, str2);
}

// A custom comparison function for qsort() that sorts integers in ascending order
int compare_integers_ascending(const void *a, const void *b) {
  const int *num1 = (const int *)a;
  const int *num2 = (const int *)b;

  // Return a negative value if num1 is less than num2,
  // a positive value if num1 is greater than num2,
  // and 0 if num1 is equal to num2
  return *num1 - *num2;
}

// A custom comparison function for qsort() that sorts structures in descending order by a specified field
typedef struct {
  int id;
  char name[20];
  float score;
} student;

int compare_students_descending(const void *a, const void *b) {
  const student *student1 = (const student *)a;
  const student *student2 = (const student *)b;

  // Sort in descending order by the score field
  return student2->score - student1->score;
}

int main() {
  // Array of strings
  const char *strings[] = {"Apple", "Banana", "Cherry", "Dog", "Elephant"};
  int num_strings = sizeof(strings) / sizeof(const char *);

  // Sort the strings in descending order using qsort() and our custom comparison function
  qsort(strings, num_strings, sizeof(const char *), compare_strings_descending);

  // Print the sorted strings
  printf("Sorted strings in descending order:\n");
  for (int i = 0; i < num_strings; i++) {
    printf("%s\n", strings[i]);
  }

  // Array of integers
  int integers[] = {5, 2, 8, 3, 1, 9, 4, 7, 6};
  int num_integers = sizeof(integers) / sizeof(int);

  // Sort the integers in ascending order using qsort() and our custom comparison function
  qsort(integers, num_integers, sizeof(int), compare_integers_ascending);

  // Print the sorted integers
  printf("Sorted integers in ascending order:\n");
  for (int i = 0; i < num_integers; i++) {
    printf("%d\n", integers[i]);
  }

  // Array of structures
  student students[] = {
      {1, "Alice", 90.5},
      {2, "Bob", 85.2},
      {3, "Carol", 92.8},
      {4, "Dave", 88.7},
      {5, "Eve", 95.1},
  };
  int num_students = sizeof(students) / sizeof(student);

  // Sort the students in descending order by score using qsort() and our custom comparison function
  qsort(students, num_students, sizeof(student), compare_students_descending);

  // Print the sorted students
  printf("Sorted students in descending order by score:\n");
  for (int i = 0; i < num_students; i++) {
    printf("ID: %d, Name: %s, Score: %.1f\n", students[i].id, students[i].name, students[i].score);
  }

  return 0;
}