//Gemma-7B DATASET v1.0 Category: Breakout Game Clone ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 5
#define HEIGHT 5

#define UP 0
#define DOWN 1
#define RIGHT 2
#define LEFT 3

int board[WIDTH][HEIGHT] = {{0, 0, 0, 0, 0},
                              {0, 0, 1, 0, 0},
                              {0, 0, 1, 1, 0},
                              {0, 0, 1, 1, 0},
                              {0, 0, 0, 0, 0}};

int player_x = 0;
int player_y = 0;

void draw_board()
{
    for (int y = 0; y < HEIGHT; y++)
    {
        for (int x = 0; x < WIDTH; x++)
        {
            printf("%c ", board[x][y] ? '#' : '.');
        }
        printf("\n");
    }
}

void move(int direction)
{
    switch (direction)
    {
        case UP:
            if (player_y > 0 && board[player_x][player_y - 1] == 0)
            {
                player_y--;
            }
            break;
        case DOWN:
            if (player_y < HEIGHT - 1 && board[player_x][player_y + 1] == 0)
            {
                player_y++;
            }
            break;
        case RIGHT:
            if (player_x < WIDTH - 1 && board[player_x + 1][player_y] == 0)
            {
                player_x++;
            }
            break;
        case LEFT:
            if (player_x > 0 && board[player_x - 1][player_y] == 0)
            {
                player_x--;
            }
            break;
    }
}

int main()
{
    draw_board();

    move(RIGHT);
    move(UP);
    move(LEFT);
    move(DOWN);

    draw_board();

    return 0;
}