//MISTRAL-7B DATASET v1.0 Category: Warehouse Management System ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEM_NAME_LENGTH 50
#define MAX_NUM_ITEMS 100
#define MAX_NUM_ORDERS 50

typedef struct {
    char name[MAX_ITEM_NAME_LENGTH];
    int stock;
} Item;

typedef struct {
    int id;
    char itemName[MAX_ITEM_NAME_LENGTH];
    int quantity;
} Order;

Item inventory[MAX_NUM_ITEMS];
Order orders[MAX_NUM_ORDERS];
int numItems = 0;
int numOrders = 0;

void addItem(const char* name, int initialStock) {
    if (numItems >= MAX_NUM_ITEMS) {
        printf("Error: Warehouse is full.\n");
        return;
    }
    strcpy(inventory[numItems].name, name);
    inventory[numItems].stock = initialStock;
    numItems++;
}

void processOrder(const char* itemName, int quantity) {
    int i;
    for (i = 0; i < numItems; i++) {
        if (strcmp(itemName, inventory[i].name) == 0) {
            if (inventory[i].stock >= quantity) {
                inventory[i].stock -= quantity;
                orders[numOrders].id = numOrders + 1;
                strcpy(orders[numOrders].itemName, itemName);
                orders[numOrders].quantity = quantity;
                numOrders++;
                printf("Order #%d processed successfully.\n", numOrders);
                return;
            } else {
                printf("Error: Insufficient stock for item %s.\n", itemName);
                return;
            }
        }
    }
    printf("Error: Item %s not found in inventory.\n", itemName);
}

int main() {
    addItem("Apple", 100);
    addItem("Banana", 50);
    addItem("Orange", 75);

    processOrder("Apple", 25);
    processOrder("Banana", 30);
    processOrder("Apple", 50);
    processOrder("Grape", 15); // Should fail

    return 0;
}