//MISTRAL-7B DATASET v1.0 Category: Queue Implementation ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_QUEUE_SIZE 100

typedef struct {
    int front;
    int rear;
    int data[MAX_QUEUE_SIZE];
} queue_t;

void enqueue(queue_t *q, int value) {
    if (q->rear == MAX_QUEUE_SIZE - 1) {
        fprintf(stderr, "Queue is full\n");
        return;
    }
    q->data[q->rear] = value;
    q->rear++;
}

int dequeue(queue_t *q) {
    if (q->front == q->rear) {
        fprintf(stderr, "Queue is empty\n");
        return -1;
    }
    int value = q->data[q->front];
    q->front++;
    return value;
}

void print_queue(queue_t *q) {
    int i;
    for (i = q->front; i < q->rear; i++) {
        printf("%d ", q->data[i]);
    }
    printf("\b\b ");
}

void initialize_queue(queue_t *q) {
    q->front = 0;
    q->rear = 0;
}

int main() {
    queue_t my_queue;
    initialize_queue(&my_queue);

    enqueue(&my_queue, 5);
    enqueue(&my_queue, 10);
    enqueue(&my_queue, 15);

    printf("Queue after enqueueing 5, 10, and 15:\n");
    print_queue(&my_queue);

    int dequeued_value;

    dequeued_value = dequeue(&my_queue);
    printf("\nDequeued value: %d\n", dequeued_value);

    dequeued_value = dequeue(&my_queue);
    printf("Dequeued value: %d\n", dequeued_value);

    dequeued_value = dequeue(&my_queue);
    printf("Dequeued value: %d\n", dequeued_value);

    printf("Queue after dequeueing 3 values:\n");
    print_queue(&my_queue);

    enqueue(&my_queue, 20);
    printf("Queue after enqueueing 20:\n");
    print_queue(&my_queue);

    return 0;
}