//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <string.h>

void packet_handler(u_char *user, const struct pcap_pkthdr *pkthdr, const u_char *packet) {
    struct iphdr *ip_header = (struct iphdr *)(packet + 14); // Skip Ethernet header
    struct tcphdr *tcp_header = (struct tcphdr *)(packet + 14 + ip_header->ihl * 4);

    // Fetching the source and destination IP addresses
    char src_ip[INET_ADDRSTRLEN], dst_ip[INET_ADDRSTRLEN];
    inet_ntop(AF_INET, &(ip_header->saddr), src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->daddr), dst_ip, INET_ADDRSTRLEN);
    
    // Artistic output
    printf("🌐 Packet Captured! 🌐\n");
    printf("---------------------------------------------------\n");
    printf("🌟 Source IP: %s\n", src_ip);
    printf("🌟 Destination IP: %s\n", dst_ip);
    printf("🌟 Protocol: %d\n", ip_header->protocol);
    printf("---------------------------------------------------\n");
    printf("📦 TCP Header:\n");
    printf("   - Source Port: %u\n", ntohs(tcp_header->source));
    printf("   - Destination Port: %u\n", ntohs(tcp_header->dest));
    printf("---------------------------------------------------\n");
    printf("🎨 Raw Packet Data:\n");
    for (int i = 0; i < pkthdr->len; i++) {
        printf("%02x ", packet[i]);
        if ((i + 1) % 16 == 0) printf("\n");
    }
    printf("\n---------------------------------------------------\n");
}

int main() {
    char *dev;               // Device to capture packets
    char errbuf[PCAP_ERRBUF_SIZE]; // Error buffer
    pcap_t *handle;         // Packet capture handle

    // Find a suitable device
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Couldn't find a device: %s\n", errbuf);
        return EXIT_FAILURE;
    }

    // Open the device for capturing packets
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Couldn't open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    printf("🎉 Network Packet Monitoring Started on: %s 🎉\n", dev);
    printf("💻 Press Ctrl+C to stop...\n\n");

    // Start capturing packets
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the handle
    pcap_close(handle);
    return EXIT_SUCCESS;
}