//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of stocks to track
#define MAX_STOCKS 10

// Define the structure of a stock
typedef struct {
    char symbol[10];
    double price;
    double change;
} Stock;

// Define the array of stocks to track
Stock stocks[MAX_STOCKS];

// Define the number of stocks to track
int num_stocks = 0;

// Function to add a stock to the array
void add_stock(char *symbol, double price, double change) {
    // Check if the array is full
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: The stock array is full.\n");
        return;
    }

    // Copy the stock data into the array
    strcpy(stocks[num_stocks].symbol, symbol);
    stocks[num_stocks].price = price;
    stocks[num_stocks].change = change;

    // Increment the number of stocks
    num_stocks++;
}

// Function to print the stock data
void print_stocks() {
    // Print the header
    printf("%-10s %-10s %-10s\n", "Symbol", "Price", "Change");

    // Print the stock data
    for (int i = 0; i < num_stocks; i++) {
        printf("%-10s %-10.2f %-10.2f\n", stocks[i].symbol, stocks[i].price, stocks[i].change);
    }
}

// Main function
int main() {
    // Add some stocks to the array
    add_stock("AAPL", 120.00, 1.00);
    add_stock("GOOG", 900.00, 2.00);
    add_stock("AMZN", 1800.00, 3.00);

    // Print the stock data
    print_stocks();

    return 0;
}