//Gemma-7B DATASET v1.0 Category: Product Inventory System ; Style: retro
#include <stdio.h>
#include <string.h>

// Define the maximum number of items in the inventory
#define MAX_ITEMS 10

// Define the structure of an item
typedef struct item {
  char name[20];
  int quantity;
  double price;
} item_t;

// Create an array of items
item_t items[MAX_ITEMS];

// Function to add an item to the inventory
void add_item(char *name, int quantity, double price) {
  int i = 0;
  for (; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {}
  strcpy(items[i].name, name);
  items[i].quantity = quantity;
  items[i].price = price;
}

// Function to remove an item from the inventory
void remove_item(char *name) {
  int i = 0;
  for (; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {
    if (strcmp(items[i].name, name) == 0) {
      items[i].name[0] = '\0';
      items[i].quantity = 0;
      items[i].price = 0.0;
    }
  }
}

// Function to list all items in the inventory
void list_items() {
  int i = 0;
  for (; items[i].name[0] != '\0'; i++) {
    printf("%s: %d, $%.2lf\n", items[i].name, items[i].quantity, items[i].price);
  }
}

// Main function
int main() {
  add_item("Apple", 10, 1.25);
  add_item("Banana", 5, 0.89);
  add_item("Orange", 7, 1.50);
  add_item("Grape", 3, 1.75);

  list_items();

  remove_item("Banana");

  list_items();

  return 0;
}