//GEMINI-pro DATASET v1.0 Category: Network Packet Monitoring ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>

/* Callback function for PCAP */
void packet_handler(u_char *user, const struct pcap_pkthdr *pkthdr, const u_char *packet) {
    printf("Packet length: %d\n", pkthdr->len);
    printf("Number of bytes: %d\n", pkthdr->caplen);
    printf("Receive time: %s\n", ctime((const time_t *) &pkthdr->ts.tv_sec));

    /* Print packet data */
    for (int i = 0; i < pkthdr->caplen; i++) {
        printf("%02x ", packet[i]);
    }
    printf("\n\n");
}

int main() {
    char *dev;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program fp;
    char filter_exp[] = "tcp and port 80";
    bpf_u_int32 net;

    /* Get the default network device */
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Error finding default network device: %s\n", errbuf);
        return EXIT_FAILURE;
    }

    /* Open the network device for packet capture */
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening network device: %s\n", errbuf);
        return EXIT_FAILURE;
    }

    /* Compile the filter expression */
    if (pcap_compile(handle, &fp, filter_exp, 0, net) == -1) {
        fprintf(stderr, "Error compiling filter expression: %s\n", pcap_geterr(handle));
        return EXIT_FAILURE;
    }

    /* Set the filter */
    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        return EXIT_FAILURE;
    }

    /* Start the packet capture loop */
    pcap_loop(handle, -1, packet_handler, NULL);

    /* Clean up */
    pcap_freecode(&fp);
    pcap_close(handle);

    return EXIT_SUCCESS;
}