//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

#define I2C_SLAVE 0x0703
#define TEMP_REG 0x00
#define TEMP_RESOLUTION 12
#define TEMP_OFFSET -46

int main() {
    int file;
    int addr = I2C_SLAVE;
    int res;
    unsigned char buf[10];
    float temp;

    if ((file = open("/dev/i2c-1", O_RDWR)) < 0) {
        printf("Failed to open the bus.\n");
        exit(1);
    }

    if (ioctl(file, I2C_SLAVE, addr) < 0) {
        printf("Failed to acquire bus access and/or talk to slave.\n");
        exit(1);
    }

    buf[0] = TEMP_REG;
    res = write(file, buf, 1);

    if (res!= 1) {
        printf("Failed to write to register.\n");
        exit(1);
    }

    usleep(10000);

    res = read(file, buf, 2);

    if (res!= 2) {
        printf("Failed to read from register.\n");
        exit(1);
    }

    temp = ((buf[0] << 8) | buf[1]) >> TEMP_RESOLUTION;
    temp = temp - TEMP_OFFSET;

    printf("Temperature: %.2f C\n", temp);

    close(file);

    return 0;
}