//GEMINI-pro DATASET v1.0 Category: Networking ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>

#define MAX_MSG_LEN 1024

int main() {
  // Create a socket
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("socket");
    exit(1);
  }

  // Bind the socket to an address
  struct sockaddr_in serv_addr;
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  serv_addr.sin_port = htons(9999);
  if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
    perror("bind");
    exit(1);
  }

  // Listen for connections
  if (listen(sockfd, 5) < 0) {
    perror("listen");
    exit(1);
  }

  // Accept a connection
  int clientfd;
  struct sockaddr_in client_addr;
  socklen_t client_addr_len = sizeof(client_addr);
  clientfd = accept(sockfd, (struct sockaddr *) &client_addr, &client_addr_len);
  if (clientfd < 0) {
    perror("accept");
    exit(1);
  }

  // Receive data from the client
  char msg[MAX_MSG_LEN];
  memset(msg, 0, MAX_MSG_LEN);
  int n = recv(clientfd, msg, MAX_MSG_LEN, 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }

  // Process the data
  printf("Received message: %s\n", msg);

  // Send data to the client
  char *response = "Hello from the server!";
  n = send(clientfd, response, strlen(response), 0);
  if (n < 0) {
    perror("send");
    exit(1);
  }

  // Close the connection
  close(clientfd);
  close(sockfd);

  return 0;
}