//Falcon2-11B DATASET v1.0 Category: Task Scheduler ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define NUM_TASKS 3

typedef struct {
    int id;
    void (*func)(void *);
    void *arg;
    int priority;
} task_t;

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;
task_t tasks[NUM_TASKS];
int task_count = 0;

void add_task(int id, void (*func)(void *), void *arg, int priority) {
    pthread_mutex_lock(&mutex);
    if (task_count >= NUM_TASKS) {
        printf("Task queue is full. Cannot add more tasks.\n");
    } else {
        tasks[task_count].id = id;
        tasks[task_count].func = func;
        tasks[task_count].arg = arg;
        tasks[task_count].priority = priority;
        task_count++;
    }
    pthread_mutex_unlock(&mutex);
}

void remove_task(int id) {
    pthread_mutex_lock(&mutex);
    for (int i = 0; i < task_count; i++) {
        if (tasks[i].id == id) {
            for (int j = i; j < task_count - 1; j++) {
                tasks[j] = tasks[j + 1];
            }
            task_count--;
            pthread_mutex_unlock(&mutex);
            return;
        }
    }
    pthread_mutex_unlock(&mutex);
    printf("Task with ID %d not found.\n", id);
}

void *task_thread(void *arg) {
    pthread_mutex_lock(&mutex);
    int task_id = (int)arg;
    task_t *task = &tasks[task_id];
    pthread_mutex_unlock(&mutex);

    task->func(task->arg);

    remove_task(task_id);
    pthread_exit(NULL);
}

int main() {
    add_task(1, printf, "Hello, world!", 1);
    add_task(2, printf, "This is a test.", 2);
    add_task(3, printf, "Another task.", 3);

    pthread_t threads[NUM_TASKS];
    for (int i = 0; i < NUM_TASKS; i++) {
        pthread_create(&threads[i], NULL, task_thread, (void *)i);
    }

    for (int i = 0; i < NUM_TASKS; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}