//Gemma-7B DATASET v1.0 Category: Simulation of the Solar System ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define NUM_PLANETS 9

typedef struct Planet {
  char name[20];
  double mass;
  double x;
  double y;
  double z;
  double dx;
  double dy;
  double dz;
} Planet;

Planet planets[NUM_PLANETS] = {
  {"Sun", 998000, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {"Mercury", 0.05, -1.52, 0.0, 0.0, -0.05, 0.0, 0.0, 0.0},
  {"Venus", 0.81, -1.51, 0.0, 0.0, -0.02, 0.0, 0.0, 0.0},
  {"Earth", 1.0, -1.50, 0.0, 0.0, -0.01, 0.0, 0.0, 0.0},
  {"Mars", 0.10, -1.49, 0.0, 0.0, -0.03, 0.0, 0.0, 0.0},
  {"Jupiter", 530, -1.48, 0.0, 0.0, -0.04, 0.0, 0.0, 0.0},
  {"Saturn", 530, -1.47, 0.0, 0.0, -0.03, 0.0, 0.0, 0.0},
  {"Uranus", 530, -1.46, 0.0, 0.0, -0.02, 0.0, 0.0, 0.0},
  {"Neptune", 530, -1.45, 0.0, 0.0, -0.01, 0.0, 0.0, 0.0}
};

void update_planets() {
  for (int i = 0; i < NUM_PLANETS; i++) {
    planets[i].x += planets[i].dx * 0.01;
    planets[i].y += planets[i].dy * 0.01;
    planets[i].z += planets[i].dz * 0.01;
  }
}

void simulate_solar_system() {
  update_planets();

  for (int i = 0; i < NUM_PLANETS; i++) {
    printf("%s's position: (%.2f, %.2f, %.2f)\n", planets[i].name, planets[i].x, planets[i].y, planets[i].z);
  }
}

int main() {
  simulate_solar_system();

  return 0;
}