//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100
#define MAX_NAME_LENGTH 50
#define MAX_PASSWORD_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH];
    char password[MAX_PASSWORD_LENGTH];
    int is_admin;
} User;

typedef struct {
    char name[MAX_NAME_LENGTH];
    int votes;
} Candidate;

User users[MAX_VOTERS];
Candidate candidates[MAX_CANDIDATES];
int num_users = 0;
int num_candidates = 0;

void add_user(char *name, char *password, int is_admin) {
    strcpy(users[num_users].name, name);
    strcpy(users[num_users].password, password);
    users[num_users].is_admin = is_admin;
    num_users++;
}

int authenticate_user(char *name, char *password) {
    for (int i = 0; i < num_users; i++) {
        if (strcmp(users[i].name, name) == 0 && strcmp(users[i].password, password) == 0) {
            return i;
        }
    }
    return -1;
}

void add_candidate(char *name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void vote(int user_id, int candidate_id) {
    candidates[candidate_id].votes++;
}

void print_results() {
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_user("admin", "password", 1);
    add_user("user1", "password1", 0);
    add_user("user2", "password2", 0);
    add_candidate("candidate1");
    add_candidate("candidate2");
    add_candidate("candidate3");

    int user_id = authenticate_user("user1", "password1");
    if (user_id >= 0) {
        for (int i = 0; i < num_candidates; i++) {
            vote(user_id, i);
        }
    }

    user_id = authenticate_user("user2", "password2");
    if (user_id >= 0) {
        for (int i = 0; i < num_candidates; i++) {
            vote(user_id, i);
        }
    }

    print_results();

    return 0;
}