//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 100
#define MAX_NAME_LENGTH 50
#define MAX_PRICE_LENGTH 10

typedef struct {
    char name[MAX_NAME_LENGTH];
    char price[MAX_PRICE_LENGTH];
} Stock;

void addStock(Stock* stocks, int numStocks, char* name, char* price) {
    if (numStocks >= MAX_STOCKS) {
        printf("Error: Cannot add more than %d stocks.\n", MAX_STOCKS);
        return;
    }

    strcpy(stocks[numStocks].name, name);
    strcpy(stocks[numStocks].price, price);

    numStocks++;
}

void updateStock(Stock* stocks, int numStocks, int index, char* newName, char* newPrice) {
    if (index >= numStocks || index < 0) {
        printf("Error: Invalid stock index.\n");
        return;
    }

    strcpy(stocks[index].name, newName);
    strcpy(stocks[index].price, newPrice);
}

void deleteStock(Stock* stocks, int numStocks, int index) {
    if (index >= numStocks || index < 0) {
        printf("Error: Invalid stock index.\n");
        return;
    }

    for (int i = index; i < numStocks - 1; i++) {
        strcpy(stocks[i].name, stocks[i + 1].name);
        strcpy(stocks[i].price, stocks[i + 1].price);
    }

    numStocks--;
}

void displayStocks(Stock* stocks, int numStocks) {
    printf("Current stocks:\n");

    for (int i = 0; i < numStocks; i++) {
        printf("%s - %s\n", stocks[i].name, stocks[i].price);
    }
}

int main() {
    Stock stocks[MAX_STOCKS];
    int numStocks = 0;

    addStock(stocks, numStocks, "Apple", "100");
    addStock(stocks, numStocks, "Microsoft", "200");
    addStock(stocks, numStocks, "Google", "300");

    displayStocks(stocks, numStocks);

    updateStock(stocks, numStocks, 0, "AAPL", "150");
    displayStocks(stocks, numStocks);

    deleteStock(stocks, numStocks, 2);
    displayStocks(stocks, numStocks);

    return 0;
}