//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LEN 50
#define MAX_FILE_SIZE 1024

typedef struct {
    char name[MAX_FILE_NAME_LEN];
    int size;
    char data[MAX_FILE_SIZE];
} File;

File files[MAX_FILES];
int num_files = 0;

void create_file(char* name, int size) {
    if (num_files >= MAX_FILES) {
        printf("Error: Maximum number of files reached.\n");
        return;
    }

    strcpy(files[num_files].name, name);
    files[num_files].size = size;
    num_files++;

    printf("File created: %s\n", name);
}

void delete_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(&files[i], 0, sizeof(File));
            num_files--;

            printf("File deleted: %s\n", name);
            return;
        }
    }

    printf("File not found: %s\n", name);
}

void read_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File content:\n");
            printf("%s", files[i].data);

            return;
        }
    }

    printf("File not found: %s\n", name);
}

void write_file(char* name, char* content) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].data, content);

            printf("File written: %s\n", name);
            return;
        }
    }

    printf("File not found: %s\n", name);
}

int main() {
    create_file("test.txt", 10);
    write_file("test.txt", "Hello, world!");
    read_file("test.txt");

    delete_file("test.txt");

    return 0;
}