//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_CUSTOMERS 100
#define MAX_ORDERS 100
#define MAX_MENU_ITEMS 20

typedef struct {
    char name[50];
    int age;
    char gender[10];
    char email[50];
} Customer;

typedef struct {
    int order_id;
    Customer customer;
    int item_id;
    int quantity;
    float price;
} Order;

typedef struct {
    int item_id;
    char name[50];
    float price;
} MenuItem;

typedef struct {
    int num_items;
    MenuItem items[MAX_MENU_ITEMS];
} Menu;

typedef struct {
    int num_customers;
    Customer customers[MAX_CUSTOMERS];
} CustomerList;

typedef struct {
    int num_orders;
    Order orders[MAX_ORDERS];
} OrderList;

typedef struct {
    Menu menu;
    CustomerList customers;
    OrderList orders;
} Cafe;

void init_menu(Menu *menu) {
    menu->num_items = 0;
}

void add_menu_item(Menu *menu, MenuItem item) {
    menu->items[menu->num_items] = item;
    menu->num_items++;
}

void init_customer_list(CustomerList *customers) {
    customers->num_customers = 0;
}

void add_customer(CustomerList *customers, Customer customer) {
    customers->customers[customers->num_customers] = customer;
    customers->num_customers++;
}

void init_order_list(OrderList *orders) {
    orders->num_orders = 0;
}

void add_order(OrderList *orders, Order order) {
    orders->orders[orders->num_orders] = order;
    orders->num_orders++;
}

Cafe init_cafe() {
    Cafe cafe;
    init_menu(&cafe.menu);
    init_customer_list(&cafe.customers);
    init_order_list(&cafe.orders);
    return cafe;
}

int main() {
    Cafe cafe = init_cafe();
    return 0;
}