//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

// A structure to represent a job
typedef struct Job {
    char id; // Job ID
    int deadline; // Deadline of the job
    int profit; // Profit of the job
} Job;

// A function to compare two jobs based on their profits
int compare(const void *a, const void *b) {
    Job *job1 = (Job *)a;
    Job *job2 = (Job *)b;
    return job2->profit - job1->profit;
}

// Function to schedule jobs to maximize profit
void scheduleJobs(Job jobs[], int n) {
    // Sort the jobs in decreasing order of their profits
    qsort(jobs, n, sizeof(Job), compare);

    // Initialize the result array
    int result[n];
    for (int i = 0; i < n; i++) {
        result[i] = -1;
    }

    // Track the current time slot
    int time = 0;

    // Iterate over the jobs
    for (int i = 0; i < n; i++) {
        // Find the latest available time slot for the job
        for (int j = jobs[i].deadline - 1; j >= 0; j--) {
            if (result[j] == -1) {
                result[j] = i;
                time++;
                break;
            }
        }
    }

    // Print the scheduled jobs
    printf("Scheduled jobs:\n");
    for (int i = 0; i < n; i++) {
        if (result[i] != -1) {
            printf("%c ", jobs[result[i]].id);
        }
    }

    // Print the maximum profit
    int maxProfit = 0;
    for (int i = 0; i < n; i++) {
        if (result[i] != -1) {
            maxProfit += jobs[result[i]].profit;
        }
    }
    printf("\nMaximum profit: %d\n", maxProfit);
}

// Main function
int main() {
    // Create an array of jobs
    Job jobs[] = {
        {'a', 2, 100},
        {'b', 1, 19},
        {'c', 2, 27},
        {'d', 1, 25},
        {'e', 3, 15}
    };

    // Size of the array
    int n = sizeof(jobs) / sizeof(jobs[0]);

    // Schedule the jobs
    scheduleJobs(jobs, n);

    return 0;
}