//Falcon-180B DATASET v1.0 Category: Database querying ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>

// Define database structure
typedef struct {
    char name[50];
    int age;
    float balance;
} Account;

// Function to create a new account
void create_account(Account* account) {
    printf("Enter your name: ");
    scanf("%s", account->name);

    printf("Enter your age: ");
    scanf("%d", &account->age);

    printf("Enter your balance: ");
    scanf("%f", &account->balance);
}

// Function to deposit money into an account
void deposit(Account* account, float amount) {
    account->balance += amount;
    printf("%s, your new balance is: %.2f\n", account->name, account->balance);
}

// Function to withdraw money from an account
void withdraw(Account* account, float amount) {
    if (account->balance >= amount) {
        account->balance -= amount;
        printf("%s, your new balance is: %.2f\n", account->name, account->balance);
    } else {
        printf("Insufficient funds.\n");
    }
}

// Function to print all accounts in the database
void print_accounts(Account accounts[], int num_accounts) {
    printf("Accounts:\n");
    for (int i = 0; i < num_accounts; i++) {
        printf("%s (%d years old) - Balance: %.2f\n", accounts[i].name, accounts[i].age, accounts[i].balance);
    }
}

// Main function
int main() {
    // Initialize database with 3 accounts
    Account accounts[3] = {{"Alice", 25, 1000.00}, {"Bob", 30, 500.00}, {"Charlie", 20, 2000.00}};
    int num_accounts = 3;

    // Print initial balances
    print_accounts(accounts, num_accounts);

    // Perform some transactions
    deposit(&accounts[0], 500.00);
    withdraw(&accounts[1], 100.00);
    deposit(&accounts[2], 1000.00);

    // Print final balances
    print_accounts(accounts, num_accounts);

    return 0;
}