//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>

#define SIZE_ETHERNET 14
#define SNAP_LEN 65535

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header;
    u_char *data;

    // Print Ethernet Header
    printf("\n================== Ethernet Header ===================\n");
    for (int i = 0; i < SIZE_ETHERNET; i++) {
        printf("%02x ", packet[i]);
        if ((i + 1) % 16 == 0) printf("\n");
    }

    // Skip Ethernet header
    packet += SIZE_ETHERNET;

    ip_header = (struct ip*) (packet);

    // Print IP Header
    printf("\n==================== IP Header ====================\n");
    printf("Source IP: %s\n", inet_ntoa(ip_header->ip_src));
    printf("Destination IP: %s\n", inet_ntoa(ip_header->ip_dst));
    printf("Protocol: %d\n", ip_header->ip_p);
    printf("Total Length: %d\n", ntohs(ip_header->ip_len));

    // Identify the protocol
    if (ip_header->ip_p == IPPROTO_TCP) {
        printf("\n=================== TCP Header ====================\n");
        struct tcphdr *tcp_header = (struct tcphdr *) (packet + (ip_header->ip_hl * 4));
        printf("Source Port: %d\n", ntohs(tcp_header->source));
        printf("Destination Port: %d\n", ntohs(tcp_header->dest));
    } else if (ip_header->ip_p == IPPROTO_UDP) {
        printf("\n=================== UDP Header ====================\n");
        struct udphdr *udp_header = (struct udphdr *) (packet + (ip_header->ip_hl * 4));
        printf("Source Port: %d\n", ntohs(udp_header->source));
        printf("Destination Port: %d\n", ntohs(udp_header->dest));
    }

    // Print Payload
    data = (u_char *)(packet + (ip_header->ip_hl * 4) + ((ip_header->ip_p == IPPROTO_TCP) ? sizeof(struct tcphdr) : sizeof(struct udphdr)));
    printf("\n===================== Payload =====================\n");
    int payload_size = header->len - (SIZE_ETHERNET + (ip_header->ip_hl * 4) + ((ip_header->ip_p == IPPROTO_TCP) ? sizeof(struct tcphdr) : sizeof(struct udphdr)));
    
    if (payload_size > 0) {
        for (int i = 0; i < payload_size; i++) {
            printf("%02x ", data[i]);
            if ((i + 1) % 16 == 0) printf("\n");
        }
        printf("\n");
    } else {
        printf("No payload\n");
    }
}

int main(int argc, char **argv) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    char *dev = argv[1];
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;

    // Open the capture device
    handle = pcap_open_live(dev, SNAP_LEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    // Start the packet capture
    pcap_loop(handle, 0, packet_handler, NULL);

    pcap_close(handle);
    return EXIT_SUCCESS;
}