//Falcon2-11B DATASET v1.0 Category: Sudoku solver ; Style: grateful
#include <stdio.h>
#include <stdlib.h>

void solveSudoku(int grid[][9]) {
    int row, col, i, j;
    
    // Check if the grid is already solved
    for (row = 0; row < 9; row++) {
        for (col = 0; col < 9; col++) {
            if (grid[row][col] == 0) {
                return;
            }
        }
    }
    
    // Loop through each cell that has not been assigned a value yet
    for (row = 0; row < 9; row++) {
        for (col = 0; col < 9; col++) {
            if (grid[row][col] == 0) {
                
                // Loop through each possible value for the current cell
                for (i = 1; i <= 9; i++) {
                    
                    // Check if the value is valid in the current row, column, and 3x3 box
                    for (j = 0; j < 9; j++) {
                        if (grid[row][j] == i || grid[j][col] == i ||
                            (row/3 == j/3 && col/3 == j%3 && grid[row/3][col/3] == i)) {
                            break;
                        }
                    }
                    
                    // If the value is valid, assign it to the current cell
                    if (j == 9) {
                        grid[row][col] = i;
                        
                        // Recursively solve the rest of the grid
                        solveSudoku(grid);
                        
                        // If the solution is valid, exit the recursive call
                        if (isValidSudoku(grid)) {
                            return;
                        }
                        
                        // If the solution is not valid, backtrack and try a different value
                        grid[row][col] = 0;
                    }
                }
            }
        }
    }
}

int isValidSudoku(int grid[][9]) {
    int row, col, i, j, k;
    
    // Check if the grid is already solved
    for (row = 0; row < 9; row++) {
        for (col = 0; col < 9; col++) {
            if (grid[row][col] == 0) {
                return 0;
            }
        }
    }
    
    // Loop through each row and column
    for (row = 0; row < 9; row++) {
        for (col = 0; col < 9; col++) {
            
            // Check if the value is already used in the current row or column
            for (i = 0; i < 9; i++) {
                if (grid[row][i] == grid[col][i]) {
                    return 0;
                }
            }
        }
    }
    
    // Loop through each 3x3 box
    for (row = 0; row < 3; row++) {
        for (col = 0; col < 3; col++) {
            for (i = 0; i < 3; i++) {
                for (j = 0; j < 3; j++) {
                    if (grid[row*3+i][col*3+j] == grid[row*3+i][col*3+j+3] || 
                        grid[row*3+i][col*3+j] == grid[row*3+i+3][col*3+j+3] || 
                        grid[row*3+i][col*3+j] == grid[row*3+i+3][col*3+j] || 
                        grid[row*3+i][col*3+j] == grid[row*3+i][col*3+j+3]) {
                        return 0;
                    }
                }
            }
        }
    }
    
    return 1;
}

int main() {
    int grid[9][9] = {
        {5,3,0,0,7,0,0,0,0},
        {6,0,0,1,9,5,0,0,0},
        {0,9,8,0,0,0,0,6,0},
        {8,0,0,0,6,0,0,0,3},
        {4,0,0,8,0,3,0,0,1},
        {7,0,0,0,2,0,0,0,6},
        {0,6,0,0,0,0,2,8,0},
        {0,0,0,4,1,9,0,0,5},
        {0,0,0,0,8,0,0,7,9}
    };
    
    solveSudoku(grid);
    
    printf("Sudoku solved!\n");
    
    return 0;
}