//Falcon-180B DATASET v1.0 Category: Weather simulation ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
    int temperature;
    int humidity;
    int windSpeed;
    int cloudCoverage;
    int precipitation;
} Weather;

void generateWeather(Weather* weather) {
    srand(time(NULL));

    // Set the temperature based on the season
    int season = rand() % 4;
    switch (season) {
        case 0: // Winter
            weather->temperature = rand() % 21 - 10;
            break;
        case 1: // Spring
            weather->temperature = rand() % 31 - 10;
            break;
        case 2: // Summer
            weather->temperature = rand() % 41 - 10;
            break;
        case 3: // Fall
            weather->temperature = rand() % 31 - 10;
            break;
    }

    // Set the humidity
    weather->humidity = rand() % 101;

    // Set the wind speed
    weather->windSpeed = rand() % 31 + 1;

    // Set the cloud coverage
    weather->cloudCoverage = rand() % 101;

    // Set the precipitation
    if (rand() % 2 == 0) {
        weather->precipitation = rand() % 11;
    } else {
        weather->precipitation = 0;
    }
}

void printWeather(Weather weather) {
    printf("Temperature: %d\n", weather.temperature);
    printf("Humidity: %d\n", weather.humidity);
    printf("Wind Speed: %d\n", weather.windSpeed);
    printf("Cloud Coverage: %d\n", weather.cloudCoverage);
    printf("Precipitation: %d\n", weather.precipitation);
}

int main() {
    Weather weather;
    generateWeather(&weather);
    printWeather(weather);

    return 0;
}