//Falcon2-11B DATASET v1.0 Category: Basic Unix-like Shell ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <pthread.h>

pthread_t child_thread[2];

void* child_process(void* arg) {
    pid_t pid;
    int status;

    pid = fork();

    if (pid == 0) {
        // Child process.
        if (fork() == 0) {
            // Another child process.
            printf("I am child process number %d\n", getpid());
            sleep(1);
            printf("I am child process number %d\n", getpid());
            exit(0);
        } else {
            // Parent process.
            printf("I am child process number %d\n", getpid());
            sleep(2);
            printf("I am child process number %d\n", getpid());
            wait(&status);
        }
    } else {
        // Parent process.
        printf("I am parent process number %d\n", getpid());
        sleep(3);
        printf("I am parent process number %d\n", getpid());
        wait(&status);
    }

    return NULL;
}

int main() {
    pthread_create(&child_thread[0], NULL, child_process, NULL);
    pthread_create(&child_thread[1], NULL, child_process, NULL);

    for (int i = 0; i < 2; i++) {
        pthread_join(child_thread[i], NULL);
    }

    return 0;
}