//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define RED 0
#define YELLOW 1
#define GREEN 2

#define DELAY 5
#define TOTAL_DELAY (DELAY * 4)

int main() {
    int state = RED;
    int delay_count = 0;
    int total_delay_count = 0;

    while (1) {
        printf("Traffic light state: ");
        switch (state) {
            case RED:
                printf("Red\n");
                break;
            case YELLOW:
                printf("Yellow\n");
                break;
            case GREEN:
                printf("Green\n");
                break;
            default:
                printf("Error\n");
                exit(1);
        }

        if (state == RED) {
            state = GREEN;
        } else if (state == GREEN) {
            state = YELLOW;
        } else if (state == YELLOW) {
            state = RED;
        }

        delay_count = 0;
        while (delay_count < DELAY) {
            printf("Delay %d...\n", delay_count);
            delay_count++;
            fflush(stdout);
            usleep(100000);
        }

        total_delay_count++;
        if (total_delay_count >= TOTAL_DELAY) {
            exit(0);
        }
    }

    return 0;
}