//Code Llama-13B DATASET v1.0 Category: Expense Tracker ; Style: creative
// Expense Tracker
#include <stdio.h>

// Structure to store expense information
struct Expense {
    char name[50];
    float amount;
};

// Function to add an expense
void addExpense(struct Expense* expense, char* name, float amount) {
    strcpy(expense->name, name);
    expense->amount = amount;
}

// Function to display all expenses
void displayExpenses(struct Expense* expenses, int numExpenses) {
    printf("Name\t\tAmount\n");
    for (int i = 0; i < numExpenses; i++) {
        printf("%s\t%.2f\n", expenses[i].name, expenses[i].amount);
    }
}

// Function to calculate total expenses
float calculateTotal(struct Expense* expenses, int numExpenses) {
    float total = 0;
    for (int i = 0; i < numExpenses; i++) {
        total += expenses[i].amount;
    }
    return total;
}

int main() {
    // Define an array of expenses
    struct Expense expenses[5];

    // Add expenses
    addExpense(&expenses[0], "Groceries", 50.00);
    addExpense(&expenses[1], "Rent", 1500.00);
    addExpense(&expenses[2], "Car Insurance", 100.00);
    addExpense(&expenses[3], "Gas", 100.00);
    addExpense(&expenses[4], "Entertainment", 200.00);

    // Display all expenses
    displayExpenses(expenses, 5);

    // Calculate total expenses
    float total = calculateTotal(expenses, 5);
    printf("Total Expenses: %.2f\n", total);

    return 0;
}