//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: mathematical
// TCP/IP Programming Example Program

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>

int main(int argc, char *argv[]) {
    // Create a TCP socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Set the address information for the server
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(8080);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    // Send a request to the server
    char *request = "Hello, server!";
    if (send(sock, request, strlen(request), 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    // Receive the response from the server
    char response[1024];
    if (recv(sock, response, sizeof(response), 0) < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    // Print the response
    printf("Received response: %s\n", response);

    // Close the socket
    close(sock);

    return EXIT_SUCCESS;
}