//Falcon-180B DATASET v1.0 Category: Graph Coloring Problem ; Style: realistic
#include <stdio.h>
#include <stdlib.h>

#define V 9
#define INF 999

int graph[V][V];
int n, m;
int color[V];
int min_color[V];
int max_color[V];

void init_graph();
void init_colors();
void print_solution();
void color_graph(int v, int c);

int main() {
    init_graph();
    init_colors();
    int i, j;
    for (i = 0; i < V; i++) {
        color_graph(i, 1);
    }
    print_solution();
    return 0;
}

void init_graph() {
    int i, j;
    for (i = 0; i < V; i++) {
        for (j = 0; j < V; j++) {
            graph[i][j] = 0;
        }
    }
}

void init_colors() {
    int i;
    for (i = 0; i < V; i++) {
        min_color[i] = i + 1;
        max_color[i] = i + 1;
    }
}

void print_solution() {
    int i;
    printf("Vertex\tColor\n");
    for (i = 0; i < V; i++) {
        printf("%d\t%d\n", i, color[i]);
    }
}

void color_graph(int v, int c) {
    int i, j;
    for (i = 0; i < V; i++) {
        if (graph[v][i] == 1) {
            if (color[i] == 0) {
                color[i] = c;
                if (c < min_color[i]) {
                    min_color[i] = c;
                }
                if (c > max_color[i]) {
                    max_color[i] = c;
                }
            } else if (color[i]!= c) {
                printf("Error: Graph is not k-colorable.\n");
                exit(0);
            }
        }
    }
}