//GPT-4o-mini DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <semaphore.h>
#include <unistd.h>

#define MAX_BAGGAGE 10
#define CONVEYOR_BELT_LENGTH 5

typedef struct {
    int id;
    char location[30];
} Baggage;

Baggage conveyorBelt[CONVEYOR_BELT_LENGTH];
int conveyorIndex = 0;

sem_t empty;
sem_t full;

void* baggageProducer(void* arg) {
    for (int i = 0; i < MAX_BAGGAGE; i++) {
        sem_wait(&empty);

        // Simulating baggage creation
        Baggage newBaggage;
        newBaggage.id = i + 1;
        snprintf(newBaggage.location, sizeof(newBaggage.location), "Location %d", rand() % 5 + 1);

        conveyorBelt[conveyorIndex] = newBaggage;
        printf("Baggage %d added to conveyor belt at index %d\n", newBaggage.id, conveyorIndex);

        conveyorIndex = (conveyorIndex + 1) % CONVEYOR_BELT_LENGTH;
        
        sem_post(&full);
        sleep(rand() % 3); // Simulating time taken to produce baggage
    }
    pthread_exit(NULL);
}

void* baggageConsumer(void* arg) {
    for (int i = 0; i < MAX_BAGGAGE; i++) {
        sem_wait(&full);

        // Retrieving baggage from conveyor belt
        int index = (conveyorIndex - 1 + CONVEYOR_BELT_LENGTH) % CONVEYOR_BELT_LENGTH;
        Baggage retrievedBaggage = conveyorBelt[index];
        printf("Baggage %d retrieved from conveyor belt from index %d to %s\n", 
               retrievedBaggage.id, index, retrievedBaggage.location);
        
        // Clear the index (simulating removal)
        conveyorBelt[index] = (Baggage){0, ""};
        
        conveyorIndex = index;

        sem_post(&empty);
        sleep(rand() % 3); // Simulating time taken to process baggage
    }
    pthread_exit(NULL);
}

int main() {
    srand(time(NULL));
    pthread_t producer, consumer;

    sem_init(&empty, 0, CONVEYOR_BELT_LENGTH);
    sem_init(&full, 0, 0);

    pthread_create(&producer, NULL, baggageProducer, NULL);
    pthread_create(&consumer, NULL, baggageConsumer, NULL);

    pthread_join(producer, NULL);
    pthread_join(consumer, NULL);

    sem_destroy(&empty);
    sem_destroy(&full);
    return 0;
}