//Falcon-180B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 80
#define HEIGHT 24
#define SPEED 3
#define DELAY 100000

char map[HEIGHT][WIDTH] = {
    "                                                ",
    "                                                ",
    " +-------------------------------------------------+ ",
    " |                                                  | ",
    " |                                                  | ",
    " |                                                  | ",
    " |                                                  | ",
    " |                                                  | ",
    " |                                                  | ",
    " |                                                  | ",
    " +-------------------------------------------------+ ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
};

void draw_map() {
    int i, j;

    for (i = 0; i < HEIGHT; i++) {
        for (j = 0; j < WIDTH; j++) {
            printf("%c", map[i][j]);
        }
        printf("\n");
    }
}

void move_vehicle(int x, int y, int dx, int dy) {
    int nx = x + dx;
    int ny = y + dy;

    if (nx >= 0 && nx < WIDTH && ny >= 0 && ny < HEIGHT) {
        if (map[ny][nx]!= '+' && map[ny][nx]!= '|') {
            x = nx;
            y = ny;
        }
    }
}

int main() {
    int x = 0, y = 0, dx = SPEED, dy = 0;
    int vehicle_x = 0, vehicle_y = 0;

    srand(time(NULL));

    system("clear");

    while (1) {
        draw_map();

        printf("Vehicle: ");
        for (int i = 0; i < 4; i++) {
            printf("-");
        }
        printf("-\n");

        if (vehicle_x == x && vehicle_y == y) {
            printf("You crashed!\n");
            break;
        }

        move_vehicle(x, y, dx, dy);

        if (vehicle_x == x && vehicle_y == y) {
            printf("You won!\n");
            break;
        }

        usleep(DELAY);
    }

    return 0;
}