//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Custom data structure for a student record
typedef struct {
    char name[50];
    int age;
    float gpa;
} Student;

// Function to compare two students by their names
int compare_names(const void *a, const void *b) {
    const Student *student1 = (const Student *)a;
    const Student *student2 = (const Student *)b;
    return strcmp(student1->name, student2->name);
}

// Function to compare two students by their ages
int compare_ages(const void *a, const void *b) {
    const Student *student1 = (const Student *)a;
    const Student *student2 = (const Student *)b;
    return student1->age - student2->age;
}

// Function to compare two students by their GPAs
int compare_gpas(const void *a, const void *b) {
    const Student *student1 = (const Student *)a;
    const Student *student2 = (const Student *)b;
    return (student1->gpa > student2->gpa) - (student1->gpa < student2->gpa);
}

// Function to print a student record
void print_student(const Student *student) {
    printf("Name: %s\n", student->name);
    printf("Age: %d\n", student->age);
    printf("GPA: %.2f\n\n", student->gpa);
}

int main() {
    // Array of student records
    Student students[] = {
        {"John Doe", 20, 3.5},
        {"Jane Smith", 19, 3.8},
        {"Michael Jones", 21, 3.2},
        {"Sarah Miller", 20, 3.9},
        {"David Brown", 19, 3.6},
    };

    // Number of students
    const int num_students = sizeof(students) / sizeof(students[0]);

    // Print the original order of students
    printf("Original order of students:\n");
    for (int i = 0; i < num_students; i++) {
        print_student(&students[i]);
    }

    // Sort the students by their names
    qsort(students, num_students, sizeof(Student), compare_names);

    // Print the sorted order of students by their names
    printf("\nSorted order of students by their names:\n");
    for (int i = 0; i < num_students; i++) {
        print_student(&students[i]);
    }

    // Sort the students by their ages
    qsort(students, num_students, sizeof(Student), compare_ages);

    // Print the sorted order of students by their ages
    printf("\nSorted order of students by their ages:\n");
    for (int i = 0; i < num_students; i++) {
        print_student(&students[i]);
    }

    // Sort the students by their GPAs
    qsort(students, num_students, sizeof(Student), compare_gpas);

    // Print the sorted order of students by their GPAs
    printf("\nSorted order of students by their GPAs:\n");
    for (int i = 0; i < num_students; i++) {
        print_student(&students[i]);
    }

    return 0;
}