//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: multivariable
#include <stdio.h>
#include <stdbool.h>

#define ROW 5
#define COL 5

// Function to print the maze
void printMaze(int maze[ROW][COL]) {
    for (int i = 0; i < ROW; i++) {
        for (int j = 0; j < COL; j++) {
            if (maze[i][j] == -1) {
                printf(". "); // Representing the path
            } else {
                printf("%d ", maze[i][j]);
            }
        }
        printf("\n");
    }
}

// Function to solve the maze using backtracking
bool solveMaze(int maze[ROW][COL], int x, int y, int solution[ROW][COL]) {
    // Check if we reached the destination
    if (x == ROW - 1 && y == COL - 1) {
        solution[x][y] = -1;
        return true;
    }

    // Check if current position is valid
    if (x >= 0 && x < ROW && y >= 0 && y < COL && maze[x][y] == 0) {
        // Mark the cell as part of the solution path
        solution[x][y] = -1;

        // Move forward in x direction
        if (solveMaze(maze, x + 1, y, solution)) {
            return true;
        }

        // Move down in y direction
        if (solveMaze(maze, x, y + 1, solution)) {
            return true;
        }

        // If none of the above movements work then backtrack
        solution[x][y] = 0;
        return false;
    }
    return false;
}

int main() {
    int maze[ROW][COL] = {
        {0, 1, 0, 0, 0},
        {0, 1, 0, 1, 0},
        {0, 0, 0, 1, 0},
        {0, 1, 1, 1, 0},
        {0, 0, 0, 0, 0}
    };

    int solution[ROW][COL] = {0};

    printf("Initial Maze:\n");
    printMaze(maze);

    if (solveMaze(maze, 0, 0, solution)) {
        printf("\nMaze Solved! Path taken:\n");
        printMaze(solution);
    } else {
        printf("\nNo solution exists.\n");
    }

    return 0;
}