//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CATEGORIES 100
#define MAX_ITEMS 1000
#define MAX_EXPENSES 1000

typedef struct {
    char name[50];
    int id;
} Category;

typedef struct {
    char name[50];
    int id;
    int category_id;
    float price;
} Item;

typedef struct {
    int category_id;
    int item_id;
    float quantity;
    float price;
    char date[20];
} Expense;

Category categories[MAX_CATEGORIES];
int num_categories = 0;

Item items[MAX_ITEMS];
int num_items = 0;

Expense expenses[MAX_EXPENSES];
int num_expenses = 0;

void add_category(char *name) {
    strcpy(categories[num_categories].name, name);
    categories[num_categories].id = num_categories + 1;
    num_categories++;
}

int get_category_id(char *name) {
    for (int i = 0; i < num_categories; i++) {
        if (strcmp(categories[i].name, name) == 0) {
            return categories[i].id;
        }
    }
    return -1;
}

void add_item(char *name, int category_id, float price) {
    strcpy(items[num_items].name, name);
    items[num_items].id = num_items + 1;
    items[num_items].category_id = category_id;
    items[num_items].price = price;
    num_items++;
}

int get_item_id(char *name) {
    for (int i = 0; i < num_items; i++) {
        if (strcmp(items[i].name, name) == 0) {
            return items[i].id;
        }
    }
    return -1;
}

void add_expense(int category_id, int item_id, float quantity, float price, char *date) {
    expenses[num_expenses].category_id = category_id;
    expenses[num_expenses].item_id = item_id;
    expenses[num_expenses].quantity = quantity;
    expenses[num_expenses].price = price;
    strcpy(expenses[num_expenses].date, date);
    num_expenses++;
}

void print_expenses() {
    for (int i = 0; i < num_expenses; i++) {
        printf("%-10d %-20s %-10d %-10.2f %s\n", i+1, categories[expenses[i].category_id-1].name, items[expenses[i].item_id-1].name, expenses[i].quantity, expenses[i].date);
    }
}

int main() {
    add_category("Food");
    add_category("Clothing");
    add_category("Entertainment");

    add_item("Groceries", 1, 50.00);
    add_item("Restaurant", 1, 20.00);
    add_item("Shirt", 2, 30.00);
    add_item("Movie Ticket", 3, 10.00);

    add_expense(1, 1, 2, 40.00, "2022-01-01");
    add_expense(1, 2, 1, 20.00, "2022-01-02");
    add_expense(2, 3, 1, 30.00, "2022-01-03");
    add_expense(3, 4, 2, 20.00, "2022-01-04");

    print_expenses();

    return 0;
}