//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: portable
#include <stdio.h>
#include <stdlib.h>

#define N 5  // Size of the maze (N x N)

// Function to print the maze
void printMaze(int maze[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (maze[i][j] == 1)
                printf("  ");  // Print space for path
            else
                printf("##");  // Print wall
        }
        printf("\n");
    }
}

// Function to check if the cell is valid to move
int isSafe(int maze[N][N], int x, int y, int visited[N][N]) {
    return (x >= 0 && x < N && y >= 0 && y < N && 
            maze[x][y] == 1 && visited[x][y] == 0);
}

// DFS algorithm to find the route
int findPath(int maze[N][N], int x, int y, int visited[N][N]) {
    // If we reach the bottom-right corner of the maze
    if (x == N - 1 && y == N - 1) {
        visited[x][y] = 1; // Mark the cell as part of the path
        return 1;
    }

    // Check if it's safe to go to the current cell
    if (isSafe(maze, x, y, visited)) {
        visited[x][y] = 1; // Mark as visited
        
        // Move in all four possible directions
        if (findPath(maze, x + 1, y, visited) || // Move down
            findPath(maze, x, y + 1, visited) || // Move right
            findPath(maze, x - 1, y, visited) || // Move up
            findPath(maze, x, y - 1, visited)) { // Move left
            return 1; // If any move is successful
        }
        
        visited[x][y] = 0; // Backtrack
    }
    return 0; // No path found
}

// Function to initialize the visited array and call the DFS
void solveMaze(int maze[N][N]) {
    int visited[N][N] = {0}; // Initialize visited cells to false
    if (!findPath(maze, 0, 0, visited)) {
        printf("No path found in the maze!\n");
        return;
    }

    // Print the maze with the path
    printf("Path through the maze:\n");
    printMaze(visited);
}

int main() {
    // A sample maze: 1 represents a path, 0 represents a wall
    int maze[N][N] = {
        {1, 0, 1, 1, 1},
        {1, 0, 0, 0, 1},
        {1, 1, 1, 0, 1},
        {0, 0, 0, 0, 1},
        {1, 1, 1, 1, 1}
    };

    printf("Original Maze:\n");
    printMaze(maze);

    solveMaze(maze);
    
    return 0;
}