//Gemma-7B DATASET v1.0 Category: Digital Auction System ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_AUCTIONS 10
#define MAX_BIDDERS 5

typedef struct Auction {
    char name[20];
    int starting_bid;
    int current_bid;
    int num_bids;
} Auction;

typedef struct Bidder {
    char name[20];
    int bids_placed;
    int total_spent;
} Bidder;

Auction auctions[MAX_AUCTIONS];
Bidder bidders[MAX_BIDDERS];

void initialize_auctions() {
    for (int i = 0; i < MAX_AUCTIONS; i++) {
        auctions[i].name[0] = '\0';
        auctions[i].starting_bid = 0;
        auctions[i].current_bid = 0;
        auctions[i].num_bids = 0;
    }
}

void initialize_bidders() {
    for (int i = 0; i < MAX_BIDDERS; i++) {
        bidders[i].name[0] = '\0';
        bidders[i].bids_placed = 0;
        bidders[i].total_spent = 0;
    }
}

void add_auction(char *name, int starting_bid) {
    for (int i = 0; i < MAX_AUCTIONS; i++) {
        if (auctions[i].name[0] == '\0') {
            strcpy(auctions[i].name, name);
            auctions[i].starting_bid = starting_bid;
            auctions[i].current_bid = starting_bid;
            auctions[i].num_bids = 0;
            return;
        }
    }

    printf("Error: No more auctions can be added.\n");
}

void add_bidder(char *name) {
    for (int i = 0; i < MAX_BIDDERS; i++) {
        if (bidders[i].name[0] == '\0') {
            strcpy(bidders[i].name, name);
            bidders[i].bids_placed = 0;
            bidders[i].total_spent = 0;
            return;
        }
    }

    printf("Error: No more bidders can be added.\n");
}

void place_bid(char *bidder_name, int amount) {
    for (int i = 0; i < MAX_BIDDERS; i++) {
        if (strcmp(bidders[i].name, bidder_name) == 0) {
            bidders[i].bids_placed++;
            auctions[0].current_bid = amount;
            auctions[0].num_bids++;
            return;
        }
    }

    printf("Error: Bidder not found.\n");
}

void display_auctions() {
    for (int i = 0; i < MAX_AUCTIONS; i++) {
        printf("Auction: %s\n", auctions[i].name);
        printf("Starting Bid: %d\n", auctions[i].starting_bid);
        printf("Current Bid: %d\n", auctions[i].current_bid);
        printf("Number of Bids: %d\n", auctions[i].num_bids);
        printf("\n");
    }
}

void display_bidders() {
    for (int i = 0; i < MAX_BIDDERS; i++) {
        printf("Bidder: %s\n", bidders[i].name);
        printf("Number of Bids Placed: %d\n", bidders[i].bids_placed);
        printf("Total Spent: %d\n", bidders[i].total_spent);
        printf("\n");
    }
}

int main() {
    initialize_auctions();
    initialize_bidders();

    add_auction("Car", 10000);
    add_auction("House", 20000);
    add_auction("Electronics", 5000);

    add_bidder("John Doe");
    add_bidder("Jane Doe");
    add_bidder("Bill Smith");

    place_bid("John Doe", 12000);
    place_bid("Jane Doe", 15000);
    place_bid("Bill Smith", 13000);

    display_auctions();
    display_bidders();

    return 0;
}