//GEMINI-pro DATASET v1.0 Category: Networking ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

// Watson's IP address
#define WATSON_IP "127.0.0.1"

// Port Watson is listening on
#define WATSON_PORT 8080

// Buffer size for receiving data from Watson
#define BUFFER_SIZE 512

int main(int argc, char *argv[]) {
    // Create a socket to connect to Watson
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket");
        exit(1);
    }

    // Set up the server address
    struct sockaddr_in serv_addr;
    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(WATSON_PORT);
    inet_pton(AF_INET, WATSON_IP, &serv_addr.sin_addr);

    // Connect to Watson
    if (connect(sock, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("connect");
        exit(1);
    }

    // Send a message to Watson
    char *message = "Elementary, my dear Watson!";
    if (send(sock, message, strlen(message), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive a response from Watson
    char buffer[BUFFER_SIZE];
    memset(buffer, 0, BUFFER_SIZE);
    if (recv(sock, buffer, BUFFER_SIZE, 0) < 0) {
        perror("recv");
        exit(1);
    }

    // Print Watson's response
    printf("Watson says: %s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}