//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100
#define VOTE_LENGTH 10

typedef struct {
    char name[VOTE_LENGTH];
    int vote;
} Voter;

typedef struct {
    char name[VOTE_LENGTH];
    int votes;
} Candidate;

Voter voters[MAX_VOTERS];
Candidate candidates[MAX_CANDIDATES];
int numVoters, numCandidates;

void initialize() {
    numVoters = 0;
    numCandidates = 0;
}

void addVoter(char* name) {
    if (numVoters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }
    strcpy(voters[numVoters].name, name);
    voters[numVoters].vote = -1;
    numVoters++;
}

void addCandidate(char* name) {
    if (numCandidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }
    strcpy(candidates[numCandidates].name, name);
    candidates[numCandidates].votes = 0;
    numCandidates++;
}

void vote(int voterIndex, int candidateIndex) {
    if (voterIndex >= numVoters || candidateIndex >= numCandidates) {
        printf("Error: Invalid voter or candidate index.\n");
        return;
    }
    if (voters[voterIndex].vote!= -1) {
        printf("Error: Voter has already voted.\n");
        return;
    }
    voters[voterIndex].vote = candidateIndex;
    candidates[candidateIndex].votes++;
}

void displayResults() {
    printf("Cyberpunk Electronic Voting System Results\n");
    printf("-----------------------------------------\n");
    for (int i = 0; i < numCandidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    initialize();
    addVoter("Neo");
    addVoter("Trinity");
    addVoter("Morpheus");
    addCandidate("Neo");
    addCandidate("Trinity");
    addCandidate("Morpheus");
    addCandidate("Agent Smith");
    vote(0, 2);
    vote(1, 0);
    vote(2, 1);
    displayResults();
    return 0;
}