//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

// Mutex
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

// Condition variable
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

// Number of threads
#define NUM_THREADS 5

// Function to be executed by each thread
void* thread_func(void* arg)
{
    int* data = (int*) arg;

    // Lock the mutex
    pthread_mutex_lock(&mutex);

    // Wait for the condition variable to be signaled
    pthread_cond_wait(&cond, &mutex);

    // Increment the data and print it
    int i = *data;
    i++;
    printf("Thread %d incremented data to %d\n", (int)pthread_self(), i);

    // Signal the condition variable
    pthread_cond_signal(&cond);

    // Unlock the mutex
    pthread_mutex_unlock(&mutex);

    // Return from the thread
    return NULL;
}

// Main function
int main()
{
    // Create threads
    pthread_t threads[NUM_THREADS];
    int data = 0;
    for (int i = 0; i < NUM_THREADS; i++)
    {
        pthread_create(&threads[i], NULL, thread_func, &data);
    }

    // Join threads
    for (int i = 0; i < NUM_THREADS; i++)
    {
        pthread_join(threads[i], NULL);
    }

    return 0;
}