//GEMINI-pro DATASET v1.0 Category: GPS Navigation Simulation ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define EARTH_RADIUS 6371.0

typedef struct {
    double latitude;
    double longitude;
    double altitude;
} Location;

typedef struct {
    Location start;
    Location end;
    double distance;
    double bearing;
} Route;

Route calculateRoute(const Location *start, const Location *end) {
    double dLat = (end->latitude - start->latitude) * M_PI / 180.0;
    double dLon = (end->longitude - start->longitude) * M_PI / 180.0;
    double lat1 = start->latitude * M_PI / 180.0;
    double lat2 = end->latitude * M_PI / 180.0;

    double a = sin(dLat / 2) * sin(dLat / 2) +
                cos(lat1) * cos(lat2) *
                sin(dLon / 2) * sin(dLon / 2);
    double c = 2 * atan2(sqrt(a), sqrt(1 - a));

    double distance = EARTH_RADIUS * c;

    double y = sin(dLon) * cos(lat2);
    double x = cos(lat1) * sin(lat2) -
                sin(lat1) * cos(lat2) * cos(dLon);
    double bearing = atan2(y, x) * 180.0 / M_PI;

    return (Route){*start, *end, distance, bearing};
}

void printRouteInfo(const Route *route) {
    printf("Start: (%f, %f, %f)\n", route->start.latitude, route->start.longitude, route->start.altitude);
    printf("End: (%f, %f, %f)\n", route->end.latitude, route->end.longitude, route->end.altitude);
    printf("Distance: %f km\n", route->distance / 1000);
    printf("Bearing: %f degrees\n", route->bearing);
}

int main(void) {
    Location start = {37.7749, -122.4194, 0.0};
    Location end = {37.7880, -122.4068, 0.0};

    Route route = calculateRoute(&start, &end);
    printRouteInfo(&route);

    return 0;
}