//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define MAX_BUFFER_SIZE 1024

typedef struct Calculator {
    char buffer[MAX_BUFFER_SIZE];
    int top;
    char operator;
    double result;
} Calculator;

void initCalculator(Calculator *calc) {
    calc->top = -1;
    calc->operator = '\0';
    calc->result = 0.0;
}

void pushNumber(Calculator *calc, double number) {
    if (calc->top == MAX_BUFFER_SIZE - 1) {
        return;
    }

    calc->buffer[++calc->top] = number;
}

void pushOperator(Calculator *calc, char operator) {
    calc->operator = operator;
}

double calculateResult(Calculator *calc) {
    double operand1 = calc->buffer[0];
    double operand2 = calc->buffer[1];

    switch (calc->operator) {
        case '+':
            return operand1 + operand2;
        case '-':
            return operand1 - operand2;
        case '*':
            return operand1 * operand2;
        case '/':
            if (operand2 == 0) {
                return -1;
            }
            return operand1 / operand2;
        default:
            return -1;
    }
}

int main() {
    Calculator calc;
    initCalculator(&calc);

    pushNumber(&calc, 10.0);
    pushOperator(&calc, '+');
    pushNumber(&calc, 20.0);
    pushOperator(&calc, '*');
    pushNumber(&calc, 30.0);
    pushOperator(&calc, '/');
    pushNumber(&calc, 40.0);

    double result = calculateResult(&calc);

    if (result != -1) {
        printf("The result is: %.2lf\n", result);
    } else {
        printf("Error: Invalid operation.\n");
    }

    return 0;
}